<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class AtsReport extends Model
{
    use HasFactory;

    protected $fillable = [
        'resume_id',
        'job_description',
        'score',
        'missing_keywords',
        'suggestions',
    ];

    protected $casts = [
        'missing_keywords' => 'array',
        'suggestions' => 'array',
    ];

    public function resume()
    {
        return $this->belongsTo(Resume::class);
    }
}
