<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Resume extends Model
{
   protected $fillable = [
        'user_id','first_name','last_name','job_title','email','phone',
        'address','city','state','country','postal_code',
        'linkedin_url','portfolio_url','summary'
    ];

    public function experiences()  { return $this->hasMany(Experience::class); }
    public function educations()   { return $this->hasMany(Education::class); }
    public function certifications(){ return $this->hasMany(Certification::class); }
    public function skills()       { return $this->hasMany(Skill::class); }
    public function atsReports()
{
    return $this->hasMany(AtsReport::class);
}
}
