<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ats_reports', function (Blueprint $table) {
             $table->id();
            $table->foreignId('resume_id')->constrained()->cascadeOnDelete();
            $table->text('job_description')->nullable();
            $table->decimal('score', 5, 2)->nullable();
            $table->json('missing_keywords')->nullable();
            $table->json('suggestions')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ats_reports');
    }
};
