@extends('layouts.app')

@section('content')
<div class="container py-4">
    <h3 class="mb-3">AI ATS Compatibility Analyzer</h3>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    {{-- Form --}}
    <form method="POST" action="{{ route('ats.analyze', $resume->id) }}">
        @csrf
        <div class="mb-3">
            <label class="form-label fw-bold">Paste Job Description</label>
            <textarea name="job_description" rows="6" class="form-control" required></textarea>
        </div>

        <div class="mb-3">
            <label class="form-label fw-bold">AI Provider</label>
            <select name="model" class="form-select">
                <option value="openai">OpenAI (GPT-4o)</option>
                <option value="gemini">Google Gemini 2.0</option>
            </select>
        </div>

        <button class="btn btn-primary">Analyze Resume 🚀</button>
    </form>

    {{-- Report Display --}}
    @if($reports->count())
        <hr class="my-4">
        <h4 class="fw-bold">Previous ATS Reports</h4>

        @foreach($reports as $report)
            <div class="card mb-3 shadow-sm">
                <div class="card-body">
                    <h5 class="mb-2">
                        Score:
                        <span class="badge bg-{{ $report->score >= 75 ? 'success' : ($report->score >= 50 ? 'warning' : 'danger') }}">
                            {{ $report->score }}/100
                        </span>
                    </h5>

                    <p><strong>Missing Keywords:</strong></p>
                    <ul>
                        @foreach($report->missing_keywords ?? [] as $word)
                            <li>{{ $word }}</li>
                        @endforeach
                    </ul>

                    <p><strong>Suggestions:</strong></p>
                    <ul>
                        @foreach($report->suggestions ?? [] as $tip)
                            <li>{{ $tip }}</li>
                        @endforeach
                    </ul>

                    <details class="mt-3">
                        <summary class="text-muted">View Job Description</summary>
                        <pre class="bg-light p-3 rounded mt-2">{{ $report->job_description }}</pre>
                    </details>
                </div>
            </div>
        @endforeach
    @endif
</div>
@endsection
