@extends('layouts.app')

@section('content')
<div class="container py-4">
    <h3 class="mb-3">Step 5: Certifications & Skills</h3>

    @if(session('success'))
      <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form method="POST" action="{{ route('resume.certifications.save', $resume->id) }}">
        @csrf

        {{-- Certifications --}}
        <div class="card mb-4 shadow-sm">
            <div class="card-header d-flex justify-content-between align-items-center">
                <span class="fw-bold">Certifications / Awards</span>
                <button type="button" id="addCert" class="btn btn-sm btn-outline-primary">+ Add Certification</button>
            </div>
            <div class="card-body" id="certContainer">
                @forelse($resume->certifications as $index => $cert)
<div class="border rounded p-3 mb-3 cert-block">
    <input type="hidden" name="certifications[{{ $index }}][id]" value="{{ $cert->id }}">
    <div class="row g-3">
        <div class="col-md-6">
            <label>Title</label>
            <input type="text" name="certifications[{{ $index }}][title]"
                   value="{{ $cert->title }}" class="form-control">
        </div>
        <div class="col-md-6">
            <label>Issuer</label>
            <input type="text" name="certifications[{{ $index }}][issuer]"
                   value="{{ $cert->issuer }}" class="form-control">
        </div>
        <div class="col-md-6">
            <label>Issue Date</label>
            <input type="date" name="certifications[{{ $index }}][issue_date]"
                   value="{{ $cert->issue_date }}" class="form-control">
        </div>
        <div class="col-md-6">
            <label>Expiry Date</label>
            <input type="date" name="certifications[{{ $index }}][expiry_date]"
                   value="{{ $cert->expiry_date }}" class="form-control">
        </div>
    </div>
</div>
@empty
<div class="border rounded p-3 mb-3 cert-block">
    <input type="hidden" name="certifications[0][id]" value="">
    <div class="row g-3">
        <div class="col-md-6">
            <label>Title</label>
            <input type="text" name="certifications[0][title]" class="form-control">
        </div>
        <div class="col-md-6">
            <label>Issuer</label>
            <input type="text" name="certifications[0][issuer]" class="form-control">
        </div>
        <div class="col-md-6">
            <label>Issue Date</label>
            <input type="date" name="certifications[0][issue_date]" class="form-control">
        </div>
        <div class="col-md-6">
            <label>Expiry Date</label>
            <input type="date" name="certifications[0][expiry_date]" class="form-control">
        </div>
    </div>
</div>
@endforelse

            </div>
        </div>

        {{-- Skills --}}
        <div class="card mb-4 shadow-sm">
            <div class="card-header fw-bold">Skills</div>
            <a href="{{ route('resume.generate.skills', $resume->id) }}" class="btn btn-outline-primary mb-3">
    🎯 Enhance Skills using AI
</a>

            <div class="card-body">
                <input type="text" name="skills" class="form-control" value="{{ $resume->skills->pluck('skill_name')->implode(', ') }}" placeholder="Comma-separated skills e.g. Python, Laravel, Docker">
                <small class="text-muted">Separate multiple skills with commas.</small>
            </div>
        </div>

        <div class="d-flex justify-content-between">
            <a href="{{ route('resume.education', $resume->id) }}" class="btn btn-outline-secondary"><i class="bi bi-arrow-left"></i> Back</a>
            <button class="btn btn-success">💾 Save Resume</button>
        </div>
    </form>
</div>

<script>
let certIndex = {{ $resume->certifications->count() ?: 1 }};
document.getElementById('addCert').onclick = function() {
  const html = `
  <div class="border rounded p-3 mb-3 cert-block">
    <input type="hidden" name="certifications[${certIndex}][id]" value="">
    <div class="row g-3">
      <div class="col-md-6">
        <label>Title</label>
        <input type="text" name="certifications[${certIndex}][title]" class="form-control">
      </div>
      <div class="col-md-6">
        <label>Issuer</label>
        <input type="text" name="certifications[${certIndex}][issuer]" class="form-control">
      </div>
      <div class="col-md-6">
        <label>Issue Date</label>
        <input type="date" name="certifications[${certIndex}][issue_date]" class="form-control">
      </div>
      <div class="col-md-6">
        <label>Expiry Date</label>
        <input type="date" name="certifications[${certIndex}][expiry_date]" class="form-control">
      </div>
    </div>
  </div>`;
  document.getElementById('certContainer').insertAdjacentHTML('beforeend', html);
  certIndex++;
};

</script>
@endsection
