@extends('layouts.app')

@section('content')
<div class="container py-4">
    <h3 class="mb-3">Step 4: Education</h3>

    @if(session('success'))
      <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form method="POST" action="{{ route('resume.education.save', $resume->id) }}">
        @csrf

        <div class="card mb-4 shadow-sm">
            <div class="card-header d-flex justify-content-between align-items-center">
                <span class="fw-bold">Education History</span>
                <button type="button" id="addEducation" class="btn btn-sm btn-outline-primary">+ Add Education</button>
            </div>
            <div class="card-body" id="educationContainer">

                {{-- Load existing education records if any --}}
                @forelse($resume->educations as $index => $edu)
    <div class="border rounded p-3 mb-3 education-block">
        <input type="hidden" name="education[{{ $index }}][id]" value="{{ $edu->id }}">
        <div class="row g-3">
            <div class="col-md-6">
                <label>Institution</label>
                <input type="text" name="education[{{ $index }}][institution]" value="{{ $edu->institution }}" class="form-control">
            </div>
            <div class="col-md-6">
                <label>Degree</label>
                <input type="text" name="education[{{ $index }}][degree]" value="{{ $edu->degree }}" class="form-control">
            </div>
            <div class="col-md-6">
                <label>Field of Study</label>
                <input type="text" name="education[{{ $index }}][field_of_study]" value="{{ $edu->field_of_study }}" class="form-control">
            </div>
            <div class="col-md-3">
                <label>Start Year</label>
                <input type="number" name="education[{{ $index }}][start_year]" value="{{ $edu->start_year }}" class="form-control">
            </div>
            <div class="col-md-3">
                <label>End Year</label>
                <input type="number" name="education[{{ $index }}][end_year]" value="{{ $edu->end_year }}" class="form-control">
            </div>
            <div class="col-12">
                <label>Description</label>
                <textarea name="education[{{ $index }}][description]" class="form-control" rows="3">{{ $edu->description }}</textarea>
            </div>
        </div>
    </div>
@empty
    {{-- default one block --}}
    <div class="border rounded p-3 mb-3 education-block">
        <input type="hidden" name="education[0][id]" value="">
        <div class="row g-3">
            <div class="col-md-6">
                <label>Institution</label>
                <input type="text" name="education[0][institution]" class="form-control">
            </div>
            <div class="col-md-6">
                <label>Degree</label>
                <input type="text" name="education[0][degree]" class="form-control">
            </div>
            <div class="col-md-6">
                <label>Field of Study</label>
                <input type="text" name="education[0][field_of_study]" class="form-control">
            </div>
            <div class="col-md-3">
                <label>Start Year</label>
                <input type="number" name="education[0][start_year]" class="form-control">
            </div>
            <div class="col-md-3">
                <label>End Year</label>
                <input type="number" name="education[0][end_year]" class="form-control">
            </div>
            <div class="col-12">
                <label>Description</label>
                <textarea name="education[0][description]" class="form-control" rows="3"></textarea>
            </div>
        </div>
    </div>
@endforelse
            </div>
        </div>

        <div class="d-flex justify-content-between">
            <a href="{{ route('resume.experience', $resume->id) }}" class="btn btn-outline-secondary"><i class="bi bi-arrow-left"></i> Back</a>
            <button class="btn btn-primary">Save & Continue →</button>
        </div>
    </form>
</div>

<script>
let eduIndex = {{ $resume->educations->count() ?: 1 }};

document.getElementById('addEducation').onclick = function() {
  const container = document.getElementById('educationContainer');
  const html = `
  <div class="border rounded p-3 mb-3 education-block">
    <input type="hidden" name="education[${eduIndex}][id]" value="">
    <div class="row g-3">
      <div class="col-md-6">
        <label>Institution</label>
        <input type="text" name="education[${eduIndex}][institution]" class="form-control">
      </div>
      <div class="col-md-6">
        <label>Degree</label>
        <input type="text" name="education[${eduIndex}][degree]" class="form-control">
      </div>
      <div class="col-md-6">
        <label>Field of Study</label>
        <input type="text" name="education[${eduIndex}][field_of_study]" class="form-control">
      </div>
      <div class="col-md-3">
        <label>Start Year</label>
        <input type="number" name="education[${eduIndex}][start_year]" class="form-control">
      </div>
      <div class="col-md-3">
        <label>End Year</label>
        <input type="number" name="education[${eduIndex}][end_year]" class="form-control">
      </div>
      <div class="col-12">
        <label>Description</label>
        <textarea name="education[${eduIndex}][description]" class="form-control" rows="3"></textarea>
      </div>
    </div>
  </div>`;
  container.insertAdjacentHTML('beforeend', html);
  eduIndex++;
};
</script>

@endsection
