@extends('layouts.app')

@section('content')
<div class="container py-4">
    <h3 class="mb-3">Step 3: Experience</h3>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form method="POST" action="{{ route('resume.experience.save', $resume->id) }}">
        @csrf

        <div class="card mb-4 shadow-sm">
            <div class="card-header d-flex justify-content-between align-items-center">
                <span class="fw-bold">Work Experience</span>
                <button type="button" id="addExperience" class="btn btn-sm btn-outline-primary">
                    + Add Experience
                </button>
            </div>

            <div class="card-body" id="experienceContainer">
                {{-- Loop through existing experiences --}}
                @forelse($resume->experiences as $index => $exp)
                    <div class="border rounded p-3 mb-4 experience-block position-relative">
                        <input type="hidden" name="experience[{{ $index }}][id]" value="{{ $exp->id }}">

                        <div class="row g-3">
                            <div class="col-md-6">
                                <label>Company</label>
                                <input type="text" name="experience[{{ $index }}][company]" value="{{ $exp->company }}" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label>Position</label>
                                <input type="text" name="experience[{{ $index }}][position]" value="{{ $exp->position }}" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label>Start Date</label>
                                <input type="date" name="experience[{{ $index }}][start_date]" value="{{ $exp->start_date }}" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label>End Date</label>
                                <input type="date" name="experience[{{ $index }}][end_date]" value="{{ $exp->end_date }}" class="form-control">
                            </div>

                            <div class="col-12">
                                <label>Location</label>
                                <input type="text" name="experience[{{ $index }}][location]" value="{{ $exp->location }}" class="form-control">
                            </div>

                            {{-- AI Generate Button --}}
                            <div class="col-12 mt-2">
                                <a href="{{ route('resume.generate.experience', [$resume->id, $exp->id]) }}"
                                   class="btn btn-sm btn-outline-success">
                                    ⚡ Generate AI Bullet Points
                                </a>
                            </div>

                            {{-- Existing Points --}}
                            <div class="col-12 mt-3">
                                <label>Responsibilities / Achievements</label>

                                @if($exp->points->count())
                                    <ul class="mt-2">
                                        @foreach($exp->points as $p)
                                            <li>{{ $p->description }}</li>
                                        @endforeach
                                    </ul>
                                @endif

                                {{-- Manual Entry Textarea --}}
                                <textarea name="experience[{{ $index }}][points][]" class="form-control mt-2" rows="3"
                                    placeholder="Add new achievement or edit existing..."></textarea>
                            </div>
                        </div>

                        {{-- Remove block --}}
                        <button type="button" class="btn btn-sm btn-danger remove-block position-absolute top-0 end-0 m-2">✕</button>
                    </div>
                @empty
                    {{-- Default empty experience --}}
                    <div class="border rounded p-3 mb-4 experience-block position-relative">
                        <input type="hidden" name="experience[0][id]" value="">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label>Company</label>
                                <input type="text" name="experience[0][company]" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label>Position</label>
                                <input type="text" name="experience[0][position]" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label>Start Date</label>
                                <input type="date" name="experience[0][start_date]" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label>End Date</label>
                                <input type="date" name="experience[0][end_date]" class="form-control">
                            </div>
                            <div class="col-12">
                                <label>Location</label>
                                <input type="text" name="experience[0][location]" class="form-control">
                            </div>
                            <div class="col-12 mt-3">
                                <label>Responsibilities / Achievements</label>
                                <textarea name="experience[0][points][]" class="form-control" rows="3" placeholder="List achievements or duties..."></textarea>
                            </div>
                        </div>
                        <button type="button" class="btn btn-sm btn-danger remove-block position-absolute top-0 end-0 m-2">✕</button>
                    </div>
                @endforelse
            </div>
        </div>

        <div class="d-flex justify-content-between">
            <a href="{{ route('resume.summary', $resume->id) }}" class="btn btn-outline-secondary">
                ← Back
            </a>
            <button type="submit" class="btn btn-primary">
                Save & Continue →
            </button>
        </div>
    </form>
</div>

{{-- === Dynamic JS Section === --}}
<script>
let expIndex = {{ $resume->experiences->count() ?: 1 }};

document.getElementById('addExperience').onclick = function() {
    const container = document.getElementById('experienceContainer');
    const html = `
        <div class="border rounded p-3 mb-4 experience-block position-relative">
            <input type="hidden" name="experience[${expIndex}][id]" value="">
            <div class="row g-3">
                <div class="col-md-6">
                    <label>Company</label>
                    <input type="text" name="experience[${expIndex}][company]" class="form-control">
                </div>
                <div class="col-md-6">
                    <label>Position</label>
                    <input type="text" name="experience[${expIndex}][position]" class="form-control">
                </div>
                <div class="col-md-6">
                    <label>Start Date</label>
                    <input type="date" name="experience[${expIndex}][start_date]" class="form-control">
                </div>
                <div class="col-md-6">
                    <label>End Date</label>
                    <input type="date" name="experience[${expIndex}][end_date]" class="form-control">
                </div>
                <div class="col-12">
                    <label>Location</label>
                    <input type="text" name="experience[${expIndex}][location]" class="form-control">
                </div>
                <div class="col-12 mt-3">
                    <label>Responsibilities / Achievements</label>
                    <textarea name="experience[${expIndex}][points][]" class="form-control" rows="3" placeholder="List achievements or duties..."></textarea>
                </div>
            </div>
            <button type="button" class="btn btn-sm btn-danger remove-block position-absolute top-0 end-0 m-2">✕</button>
        </div>`;
    container.insertAdjacentHTML('beforeend', html);
    expIndex++;
};

// remove block
document.addEventListener('click', function(e) {
    if (e.target.classList.contains('remove-block')) {
        e.target.closest('.experience-block').remove();
    }
});
</script>
@endsection
