@extends('layouts.app')

@section('content')
<div class="container py-4">
    <h3 class="mb-3">Step 1: Personal Information</h3>

    @if(session('success'))
      <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form method="POST" action="{{ route('resume.personal.save') }}">
        @csrf

        <div class="card mb-4">
            <div class="card-body row g-3">
                <div class="col-md-6">
                    <label class="form-label">First Name</label>
                    <input type="text" name="first_name" value="{{ $resume->first_name }}" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Last Name</label>
                    <input type="text" name="last_name" value="{{ $resume->last_name }}" class="form-control">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Job Title</label>
                    <input type="text" name="job_title" value="{{ $resume->job_title }}" class="form-control">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Email</label>
                    <input type="email" name="email" value="{{ $resume->email }}" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Phone</label>
                    <input type="text" name="phone" value="{{ $resume->phone }}" class="form-control">
                </div>
                <div class="col-md-6">
                    <label class="form-label">LinkedIn URL</label>
                    <input type="text" name="linkedin_url" value="{{ $resume->linkedin_url }}" class="form-control">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Portfolio URL</label>
                    <input type="text" name="portfolio_url" value="{{ $resume->portfolio_url }}" class="form-control">
                </div>
            </div>
        </div>

        <button class="btn btn-primary">Save & Continue →</button>
    </form>
</div>
@endsection
