<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{ $resume->first_name }} {{ $resume->last_name }} - Resume</title>
    <style>
        /* ===== Basic Styling for PDF ===== */
        body {
            font-family: 'Helvetica', 'Arial', sans-serif;
            color: #333;
            margin: 20px;
            line-height: 1.5;
        }
        h2, h3, h4, h5 {
            color: #222;
            margin-bottom: 6px;
        }
        h2 {
            font-size: 24px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        h5 {
            font-size: 16px;
            border-bottom: 1px solid #ccc;
            padding-bottom: 4px;
            margin-top: 20px;
        }
        .contact {
            font-size: 12px;
            color: #666;
        }
        .section {
            margin-top: 20px;
        }
        .experience, .education {
            margin-bottom: 10px;
        }
        ul {
            margin: 0;
            padding-left: 20px;
        }
        .skills span {
            display: inline-block;
            background: #f0f0f0;
            padding: 3px 8px;
            margin: 2px;
            border-radius: 4px;
            font-size: 12px;
        }
        .name-block {
            text-align: center;
            margin-bottom: 20px;
        }
        .name-block h2 {
            margin-bottom: 5px;
        }
        .summary {
            margin-top: 10px;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="name-block">
        <h2>{{ ucfirst($resume->first_name) }} {{ ucfirst($resume->last_name) }}</h2>
        <p class="contact">{{ $resume->job_title }}</p>
        <p class="contact">
            {{ $resume->email }} | {{ $resume->phone }} | {{ $resume->city }}, {{ $resume->country }}
        </p>
        @if($resume->linkedin_url)
            <p class="contact"><a href="{{ $resume->linkedin_url }}">{{ $resume->linkedin_url }}</a></p>
        @endif
    </div>

    @if($resume->summary)
    <div class="section">
        <h5>Professional Summary</h5>
        <p class="summary">{{ $resume->summary }}</p>
    </div>
    @endif

    @if($resume->experiences->count())
    <div class="section">
        <h5>Experience</h5>
        @foreach($resume->experiences as $exp)
            <div class="experience">
                <strong>{{ $exp->position }}</strong> — {{ $exp->company }} <br>
                <small>
                    {{ $exp->start_date ? \Carbon\Carbon::parse($exp->start_date)->format('M Y') : '' }}
                    - {{ $exp->end_date ? \Carbon\Carbon::parse($exp->end_date)->format('M Y') : 'Present' }}
                    | {{ $exp->location }}
                </small>
                @if($exp->points->count())
                    <ul>
                        @foreach($exp->points as $point)
                            <li>{{ $point->description }}</li>
                        @endforeach
                    </ul>
                @endif
            </div>
        @endforeach
    </div>
    @endif

    @if($resume->educations->count())
    <div class="section">
        <h5>Education</h5>
        @foreach($resume->educations as $edu)
            <div class="education">
                <strong>{{ $edu->degree }}</strong> — {{ $edu->institution }} <br>
                <small>{{ $edu->start_year }} - {{ $edu->end_year }}</small>
                @if($edu->field_of_study)
                    <p><em>{{ $edu->field_of_study }}</em></p>
                @endif
                @if($edu->description)
                    <p>{{ $edu->description }}</p>
                @endif
            </div>
        @endforeach
    </div>
    @endif

    @if($resume->certifications->count())
    <div class="section">
        <h5>Certifications & Awards</h5>
        <ul>
            @foreach($resume->certifications as $cert)
                <li>
                    <strong>{{ $cert->title }}</strong> — {{ $cert->issuer }}
                    @if($cert->issue_date)
                        ({{ \Carbon\Carbon::parse($cert->issue_date)->format('Y') }})
                    @endif
                </li>
            @endforeach
        </ul>
    </div>
    @endif

    @if($resume->skills->count())
    <div class="section skills">
        <h5>Skills</h5>
        @foreach($resume->skills as $skill)
            <span>{{ $skill->skill_name }}</span>
        @endforeach
    </div>
    @endif
</body>
</html>
