<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ResumeController;
use App\Http\Controllers\ATSController;

Route::get('/resume/{resume}/generate-summary', [ResumeController::class, 'generateSummary'])->name('resume.generate.summary');
Route::get('/resume/{resume}/generate-skills', [ResumeController::class, 'generateSkills'])->name('resume.generate.skills');
Route::get('/resume/{resume}/generate-experience/{experience}', [ResumeController::class, 'generateExperience'])->name('resume.generate.experience');


Route::get('/resume/ats/{resume}', [ATSController::class, 'form'])->name('ats.form');
Route::post('/resume/ats/{resume}', [ATSController::class, 'analyze'])->name('ats.analyze');

Route::middleware(['auth'])->group(function () {
    Route::get('/resume/personal', [ResumeController::class, 'personal'])->name('resume.personal');
    Route::post('/resume/personal', [ResumeController::class, 'savePersonal'])->name('resume.personal.save');

    Route::get('/resume/summary/{resume}', [ResumeController::class, 'summary'])->name('resume.summary');
    Route::post('/resume/summary/{resume}', [ResumeController::class, 'saveSummary'])->name('resume.summary.save');

    Route::get('/resume/experience/{resume}', [ResumeController::class, 'experience'])->name('resume.experience');
    Route::post('/resume/experience/{resume}', [ResumeController::class, 'saveExperience'])->name('resume.experience.save');

    Route::get('/resume/education/{resume}', [ResumeController::class, 'education'])->name('resume.education');
    Route::post('/resume/education/{resume}', [ResumeController::class, 'saveEducation'])->name('resume.education.save');

    Route::get('/resume/certifications/{resume}', [ResumeController::class, 'certifications'])->name('resume.certifications');
    Route::post('/resume/certifications/{resume}', [ResumeController::class, 'saveCertifications'])->name('resume.certifications.save');
});


Route::get('/resume/preview/{resume}/{template?}', [ResumeController::class, 'preview'])
    ->name('resume.preview');
    Route::get('/resume/download/{resume}', [ResumeController::class, 'download'])
    ->name('resume.download');

Route::middleware(['auth'])->group(function () {
    Route::post('/resumes', [ResumeController::class, 'store'])->name('resumes.store');
});

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
