

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <h3 class="mb-3">Step 4: Education</h3>

    <?php if(session('success')): ?>
      <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('resume.education.save', $resume->id)); ?>">
        <?php echo csrf_field(); ?>

        <div class="card mb-4 shadow-sm">
            <div class="card-header d-flex justify-content-between align-items-center">
                <span class="fw-bold">Education History</span>
                <button type="button" id="addEducation" class="btn btn-sm btn-outline-primary">+ Add Education</button>
            </div>
            <div class="card-body" id="educationContainer">

                
                <?php $__empty_1 = true; $__currentLoopData = $resume->educations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $edu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="border rounded p-3 mb-3 education-block">
        <input type="hidden" name="education[<?php echo e($index); ?>][id]" value="<?php echo e($edu->id); ?>">
        <div class="row g-3">
            <div class="col-md-6">
                <label>Institution</label>
                <input type="text" name="education[<?php echo e($index); ?>][institution]" value="<?php echo e($edu->institution); ?>" class="form-control">
            </div>
            <div class="col-md-6">
                <label>Degree</label>
                <input type="text" name="education[<?php echo e($index); ?>][degree]" value="<?php echo e($edu->degree); ?>" class="form-control">
            </div>
            <div class="col-md-6">
                <label>Field of Study</label>
                <input type="text" name="education[<?php echo e($index); ?>][field_of_study]" value="<?php echo e($edu->field_of_study); ?>" class="form-control">
            </div>
            <div class="col-md-3">
                <label>Start Year</label>
                <input type="number" name="education[<?php echo e($index); ?>][start_year]" value="<?php echo e($edu->start_year); ?>" class="form-control">
            </div>
            <div class="col-md-3">
                <label>End Year</label>
                <input type="number" name="education[<?php echo e($index); ?>][end_year]" value="<?php echo e($edu->end_year); ?>" class="form-control">
            </div>
            <div class="col-12">
                <label>Description</label>
                <textarea name="education[<?php echo e($index); ?>][description]" class="form-control" rows="3"><?php echo e($edu->description); ?></textarea>
            </div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    
    <div class="border rounded p-3 mb-3 education-block">
        <input type="hidden" name="education[0][id]" value="">
        <div class="row g-3">
            <div class="col-md-6">
                <label>Institution</label>
                <input type="text" name="education[0][institution]" class="form-control">
            </div>
            <div class="col-md-6">
                <label>Degree</label>
                <input type="text" name="education[0][degree]" class="form-control">
            </div>
            <div class="col-md-6">
                <label>Field of Study</label>
                <input type="text" name="education[0][field_of_study]" class="form-control">
            </div>
            <div class="col-md-3">
                <label>Start Year</label>
                <input type="number" name="education[0][start_year]" class="form-control">
            </div>
            <div class="col-md-3">
                <label>End Year</label>
                <input type="number" name="education[0][end_year]" class="form-control">
            </div>
            <div class="col-12">
                <label>Description</label>
                <textarea name="education[0][description]" class="form-control" rows="3"></textarea>
            </div>
        </div>
    </div>
<?php endif; ?>
            </div>
        </div>

        <div class="d-flex justify-content-between">
            <a href="<?php echo e(route('resume.experience', $resume->id)); ?>" class="btn btn-outline-secondary"><i class="bi bi-arrow-left"></i> Back</a>
            <button class="btn btn-primary">Save & Continue →</button>
        </div>
    </form>
</div>

<script>
let eduIndex = <?php echo e($resume->educations->count() ?: 1); ?>;

document.getElementById('addEducation').onclick = function() {
  const container = document.getElementById('educationContainer');
  const html = `
  <div class="border rounded p-3 mb-3 education-block">
    <input type="hidden" name="education[${eduIndex}][id]" value="">
    <div class="row g-3">
      <div class="col-md-6">
        <label>Institution</label>
        <input type="text" name="education[${eduIndex}][institution]" class="form-control">
      </div>
      <div class="col-md-6">
        <label>Degree</label>
        <input type="text" name="education[${eduIndex}][degree]" class="form-control">
      </div>
      <div class="col-md-6">
        <label>Field of Study</label>
        <input type="text" name="education[${eduIndex}][field_of_study]" class="form-control">
      </div>
      <div class="col-md-3">
        <label>Start Year</label>
        <input type="number" name="education[${eduIndex}][start_year]" class="form-control">
      </div>
      <div class="col-md-3">
        <label>End Year</label>
        <input type="number" name="education[${eduIndex}][end_year]" class="form-control">
      </div>
      <div class="col-12">
        <label>Description</label>
        <textarea name="education[${eduIndex}][description]" class="form-control" rows="3"></textarea>
      </div>
    </div>
  </div>`;
  container.insertAdjacentHTML('beforeend', html);
  eduIndex++;
};
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\portfolioninja\resources\views/resumes/education.blade.php ENDPATH**/ ?>