

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <h3 class="mb-3">AI ATS Compatibility Analyzer</h3>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    
    <form method="POST" action="<?php echo e(route('ats.analyze', $resume->id)); ?>">
        <?php echo csrf_field(); ?>
        <div class="mb-3">
            <label class="form-label fw-bold">Paste Job Description</label>
            <textarea name="job_description" rows="6" class="form-control" required></textarea>
        </div>

        <div class="mb-3">
            <label class="form-label fw-bold">AI Provider</label>
            <select name="model" class="form-select">
                <option value="openai">OpenAI (GPT-4o)</option>
                <option value="gemini">Google Gemini 2.0</option>
            </select>
        </div>

        <button class="btn btn-primary">Analyze Resume 🚀</button>
    </form>

    
    <?php if($reports->count()): ?>
        <hr class="my-4">
        <h4 class="fw-bold">Previous ATS Reports</h4>

        <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="card mb-3 shadow-sm">
                <div class="card-body">
                    <h5 class="mb-2">
                        Score:
                        <span class="badge bg-<?php echo e($report->score >= 75 ? 'success' : ($report->score >= 50 ? 'warning' : 'danger')); ?>">
                            <?php echo e($report->score); ?>/100
                        </span>
                    </h5>

                    <p><strong>Missing Keywords:</strong></p>
                    <ul>
                        <?php $__currentLoopData = $report->missing_keywords ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $word): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($word); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>

                    <p><strong>Suggestions:</strong></p>
                    <ul>
                        <?php $__currentLoopData = $report->suggestions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($tip); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>

                    <details class="mt-3">
                        <summary class="text-muted">View Job Description</summary>
                        <pre class="bg-light p-3 rounded mt-2"><?php echo e($report->job_description); ?></pre>
                    </details>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\portfolioninja\resources\views/resumes/ats.blade.php ENDPATH**/ ?>