

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <h3 class="mb-3">Step 5: Certifications & Skills</h3>

    <?php if(session('success')): ?>
      <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('resume.certifications.save', $resume->id)); ?>">
        <?php echo csrf_field(); ?>

        
        <div class="card mb-4 shadow-sm">
            <div class="card-header d-flex justify-content-between align-items-center">
                <span class="fw-bold">Certifications / Awards</span>
                <button type="button" id="addCert" class="btn btn-sm btn-outline-primary">+ Add Certification</button>
            </div>
            <div class="card-body" id="certContainer">
                <?php $__empty_1 = true; $__currentLoopData = $resume->certifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $cert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
<div class="border rounded p-3 mb-3 cert-block">
    <input type="hidden" name="certifications[<?php echo e($index); ?>][id]" value="<?php echo e($cert->id); ?>">
    <div class="row g-3">
        <div class="col-md-6">
            <label>Title</label>
            <input type="text" name="certifications[<?php echo e($index); ?>][title]"
                   value="<?php echo e($cert->title); ?>" class="form-control">
        </div>
        <div class="col-md-6">
            <label>Issuer</label>
            <input type="text" name="certifications[<?php echo e($index); ?>][issuer]"
                   value="<?php echo e($cert->issuer); ?>" class="form-control">
        </div>
        <div class="col-md-6">
            <label>Issue Date</label>
            <input type="date" name="certifications[<?php echo e($index); ?>][issue_date]"
                   value="<?php echo e($cert->issue_date); ?>" class="form-control">
        </div>
        <div class="col-md-6">
            <label>Expiry Date</label>
            <input type="date" name="certifications[<?php echo e($index); ?>][expiry_date]"
                   value="<?php echo e($cert->expiry_date); ?>" class="form-control">
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
<div class="border rounded p-3 mb-3 cert-block">
    <input type="hidden" name="certifications[0][id]" value="">
    <div class="row g-3">
        <div class="col-md-6">
            <label>Title</label>
            <input type="text" name="certifications[0][title]" class="form-control">
        </div>
        <div class="col-md-6">
            <label>Issuer</label>
            <input type="text" name="certifications[0][issuer]" class="form-control">
        </div>
        <div class="col-md-6">
            <label>Issue Date</label>
            <input type="date" name="certifications[0][issue_date]" class="form-control">
        </div>
        <div class="col-md-6">
            <label>Expiry Date</label>
            <input type="date" name="certifications[0][expiry_date]" class="form-control">
        </div>
    </div>
</div>
<?php endif; ?>

            </div>
        </div>

        
        <div class="card mb-4 shadow-sm">
            <div class="card-header fw-bold">Skills</div>
            <div class="card-body">
                <input type="text" name="skills" class="form-control" value="<?php echo e($resume->skills->pluck('skill_name')->implode(', ')); ?>" placeholder="Comma-separated skills e.g. Python, Laravel, Docker">
                <small class="text-muted">Separate multiple skills with commas.</small>
            </div>
        </div>

        <div class="d-flex justify-content-between">
            <a href="<?php echo e(route('resume.education', $resume->id)); ?>" class="btn btn-outline-secondary"><i class="bi bi-arrow-left"></i> Back</a>
            <button class="btn btn-success">💾 Save Resume</button>
        </div>
    </form>
</div>

<script>
let certIndex = <?php echo e($resume->certifications->count() ?: 1); ?>;
document.getElementById('addCert').onclick = function() {
  const html = `
  <div class="border rounded p-3 mb-3 cert-block">
    <input type="hidden" name="certifications[${certIndex}][id]" value="">
    <div class="row g-3">
      <div class="col-md-6">
        <label>Title</label>
        <input type="text" name="certifications[${certIndex}][title]" class="form-control">
      </div>
      <div class="col-md-6">
        <label>Issuer</label>
        <input type="text" name="certifications[${certIndex}][issuer]" class="form-control">
      </div>
      <div class="col-md-6">
        <label>Issue Date</label>
        <input type="date" name="certifications[${certIndex}][issue_date]" class="form-control">
      </div>
      <div class="col-md-6">
        <label>Expiry Date</label>
        <input type="date" name="certifications[${certIndex}][expiry_date]" class="form-control">
      </div>
    </div>
  </div>`;
  document.getElementById('certContainer').insertAdjacentHTML('beforeend', html);
  certIndex++;
};

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\portfolioninja\resources\views/resumes/certifications.blade.php ENDPATH**/ ?>