

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <h3 class="mb-3">Step 3: Experience</h3>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('resume.experience.save', $resume->id)); ?>">
        <?php echo csrf_field(); ?>

        <div class="card mb-4 shadow-sm">
            <div class="card-header d-flex justify-content-between align-items-center">
                <span class="fw-bold">Work Experience</span>
                <button type="button" id="addExperience" class="btn btn-sm btn-outline-primary">
                    + Add Experience
                </button>
            </div>

            <div class="card-body" id="experienceContainer">
                
                <?php $__empty_1 = true; $__currentLoopData = $resume->experiences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $exp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="border rounded p-3 mb-4 experience-block position-relative">
                        <input type="hidden" name="experience[<?php echo e($index); ?>][id]" value="<?php echo e($exp->id); ?>">

                        <div class="row g-3">
                            <div class="col-md-6">
                                <label>Company</label>
                                <input type="text" name="experience[<?php echo e($index); ?>][company]" value="<?php echo e($exp->company); ?>" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label>Position</label>
                                <input type="text" name="experience[<?php echo e($index); ?>][position]" value="<?php echo e($exp->position); ?>" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label>Start Date</label>
                                <input type="date" name="experience[<?php echo e($index); ?>][start_date]" value="<?php echo e($exp->start_date); ?>" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label>End Date</label>
                                <input type="date" name="experience[<?php echo e($index); ?>][end_date]" value="<?php echo e($exp->end_date); ?>" class="form-control">
                            </div>

                            <div class="col-12">
                                <label>Location</label>
                                <input type="text" name="experience[<?php echo e($index); ?>][location]" value="<?php echo e($exp->location); ?>" class="form-control">
                            </div>

                            
                            <div class="col-12 mt-2">
                                <a href="<?php echo e(route('resume.generate.experience', [$resume->id, $exp->id])); ?>"
                                   class="btn btn-sm btn-outline-success">
                                    ⚡ Generate AI Bullet Points
                                </a>
                            </div>

                            
                            <div class="col-12 mt-3">
                                <label>Responsibilities / Achievements</label>

                                <?php if($exp->points->count()): ?>
                                    <ul class="mt-2">
                                        <?php $__currentLoopData = $exp->points; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($p->description); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                <?php endif; ?>

                                
                                <textarea name="experience[<?php echo e($index); ?>][points][]" class="form-control mt-2" rows="3"
                                    placeholder="Add new achievement or edit existing..."></textarea>
                            </div>
                        </div>

                        
                        <button type="button" class="btn btn-sm btn-danger remove-block position-absolute top-0 end-0 m-2">✕</button>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    
                    <div class="border rounded p-3 mb-4 experience-block position-relative">
                        <input type="hidden" name="experience[0][id]" value="">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label>Company</label>
                                <input type="text" name="experience[0][company]" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label>Position</label>
                                <input type="text" name="experience[0][position]" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label>Start Date</label>
                                <input type="date" name="experience[0][start_date]" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label>End Date</label>
                                <input type="date" name="experience[0][end_date]" class="form-control">
                            </div>
                            <div class="col-12">
                                <label>Location</label>
                                <input type="text" name="experience[0][location]" class="form-control">
                            </div>
                            <div class="col-12 mt-3">
                                <label>Responsibilities / Achievements</label>
                                <textarea name="experience[0][points][]" class="form-control" rows="3" placeholder="List achievements or duties..."></textarea>
                            </div>
                        </div>
                        <button type="button" class="btn btn-sm btn-danger remove-block position-absolute top-0 end-0 m-2">✕</button>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="d-flex justify-content-between">
            <a href="<?php echo e(route('resume.summary', $resume->id)); ?>" class="btn btn-outline-secondary">
                ← Back
            </a>
            <button type="submit" class="btn btn-primary">
                Save & Continue →
            </button>
        </div>
    </form>
</div>


<script>
let expIndex = <?php echo e($resume->experiences->count() ?: 1); ?>;

document.getElementById('addExperience').onclick = function() {
    const container = document.getElementById('experienceContainer');
    const html = `
        <div class="border rounded p-3 mb-4 experience-block position-relative">
            <input type="hidden" name="experience[${expIndex}][id]" value="">
            <div class="row g-3">
                <div class="col-md-6">
                    <label>Company</label>
                    <input type="text" name="experience[${expIndex}][company]" class="form-control">
                </div>
                <div class="col-md-6">
                    <label>Position</label>
                    <input type="text" name="experience[${expIndex}][position]" class="form-control">
                </div>
                <div class="col-md-6">
                    <label>Start Date</label>
                    <input type="date" name="experience[${expIndex}][start_date]" class="form-control">
                </div>
                <div class="col-md-6">
                    <label>End Date</label>
                    <input type="date" name="experience[${expIndex}][end_date]" class="form-control">
                </div>
                <div class="col-12">
                    <label>Location</label>
                    <input type="text" name="experience[${expIndex}][location]" class="form-control">
                </div>
                <div class="col-12 mt-3">
                    <label>Responsibilities / Achievements</label>
                    <textarea name="experience[${expIndex}][points][]" class="form-control" rows="3" placeholder="List achievements or duties..."></textarea>
                </div>
            </div>
            <button type="button" class="btn btn-sm btn-danger remove-block position-absolute top-0 end-0 m-2">✕</button>
        </div>`;
    container.insertAdjacentHTML('beforeend', html);
    expIndex++;
};

// remove block
document.addEventListener('click', function(e) {
    if (e.target.classList.contains('remove-block')) {
        e.target.closest('.experience-block').remove();
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\portfolioninja\resources\views/resumes/experience.blade.php ENDPATH**/ ?>