<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($resume->first_name); ?> <?php echo e($resume->last_name); ?> - Resume</title>
    <style>
        /* ===== Basic Styling for PDF ===== */
        body {
            font-family: 'Helvetica', 'Arial', sans-serif;
            color: #333;
            margin: 20px;
            line-height: 1.5;
        }
        h2, h3, h4, h5 {
            color: #222;
            margin-bottom: 6px;
        }
        h2 {
            font-size: 24px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        h5 {
            font-size: 16px;
            border-bottom: 1px solid #ccc;
            padding-bottom: 4px;
            margin-top: 20px;
        }
        .contact {
            font-size: 12px;
            color: #666;
        }
        .section {
            margin-top: 20px;
        }
        .experience, .education {
            margin-bottom: 10px;
        }
        ul {
            margin: 0;
            padding-left: 20px;
        }
        .skills span {
            display: inline-block;
            background: #f0f0f0;
            padding: 3px 8px;
            margin: 2px;
            border-radius: 4px;
            font-size: 12px;
        }
        .name-block {
            text-align: center;
            margin-bottom: 20px;
        }
        .name-block h2 {
            margin-bottom: 5px;
        }
        .summary {
            margin-top: 10px;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="name-block">
        <h2><?php echo e(ucfirst($resume->first_name)); ?> <?php echo e(ucfirst($resume->last_name)); ?></h2>
        <p class="contact"><?php echo e($resume->job_title); ?></p>
        <p class="contact">
            <?php echo e($resume->email); ?> | <?php echo e($resume->phone); ?> | <?php echo e($resume->city); ?>, <?php echo e($resume->country); ?>

        </p>
        <?php if($resume->linkedin_url): ?>
            <p class="contact"><a href="<?php echo e($resume->linkedin_url); ?>"><?php echo e($resume->linkedin_url); ?></a></p>
        <?php endif; ?>
    </div>

    <?php if($resume->summary): ?>
    <div class="section">
        <h5>Professional Summary</h5>
        <p class="summary"><?php echo e($resume->summary); ?></p>
    </div>
    <?php endif; ?>

    <?php if($resume->experiences->count()): ?>
    <div class="section">
        <h5>Experience</h5>
        <?php $__currentLoopData = $resume->experiences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="experience">
                <strong><?php echo e($exp->position); ?></strong> — <?php echo e($exp->company); ?> <br>
                <small>
                    <?php echo e($exp->start_date ? \Carbon\Carbon::parse($exp->start_date)->format('M Y') : ''); ?>

                    - <?php echo e($exp->end_date ? \Carbon\Carbon::parse($exp->end_date)->format('M Y') : 'Present'); ?>

                    | <?php echo e($exp->location); ?>

                </small>
                <?php if($exp->points->count()): ?>
                    <ul>
                        <?php $__currentLoopData = $exp->points; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($point->description); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                <?php endif; ?>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <?php endif; ?>

    <?php if($resume->educations->count()): ?>
    <div class="section">
        <h5>Education</h5>
        <?php $__currentLoopData = $resume->educations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $edu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="education">
                <strong><?php echo e($edu->degree); ?></strong> — <?php echo e($edu->institution); ?> <br>
                <small><?php echo e($edu->start_year); ?> - <?php echo e($edu->end_year); ?></small>
                <?php if($edu->field_of_study): ?>
                    <p><em><?php echo e($edu->field_of_study); ?></em></p>
                <?php endif; ?>
                <?php if($edu->description): ?>
                    <p><?php echo e($edu->description); ?></p>
                <?php endif; ?>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <?php endif; ?>

    <?php if($resume->certifications->count()): ?>
    <div class="section">
        <h5>Certifications & Awards</h5>
        <ul>
            <?php $__currentLoopData = $resume->certifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li>
                    <strong><?php echo e($cert->title); ?></strong> — <?php echo e($cert->issuer); ?>

                    <?php if($cert->issue_date): ?>
                        (<?php echo e(\Carbon\Carbon::parse($cert->issue_date)->format('Y')); ?>)
                    <?php endif; ?>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
    <?php endif; ?>

    <?php if($resume->skills->count()): ?>
    <div class="section skills">
        <h5>Skills</h5>
        <?php $__currentLoopData = $resume->skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <span><?php echo e($skill->skill_name); ?></span>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <?php endif; ?>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\portfolioninja\resources\views/resumes/templates/classic.blade.php ENDPATH**/ ?>